/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.SelectUpdateFilesModel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoFileFilter;
import DE.siemens.ad.logo.util.Version;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectUpdateFilesPanel
extends WizardInputPanel {
    private JButton ivjaddButton = null;
    private JPanel ivjJPanel1 = null;
    private JPanel ivjJPanel2 = null;
    private JPanel ivjJPanel3 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JScrollPane ivjJScrollPane2 = null;
    private JList ivjlModules = null;
    private JButton ivjremoveButton = null;
    private JTextArea ivjtaDescription = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JLabel ivjlblModules = null;
    private JLabel ivjlblDescription = null;
    protected String lastDirectory = "";

    public SelectUpdateFilesPanel(WizardPanelModel panelModel) {
        super(panelModel);
        this.initialize();
        this.initializeFieldContents();
        this.getaddButton().setIcon(Global.getIcon("Open.gif"));
        this.gettaDescription().setBackground(UIManager.getColor("Panel.background"));
        this.gettaDescription().setEditable(false);
        this.getlModules().setModel(new DefaultListModel());
        this.getlModules().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (SelectUpdateFilesPanel.this.getlModules().getSelectedIndices().length != 1) {
                    SelectUpdateFilesPanel.this.gettaDescription().setText("");
                } else {
                    SelectUpdateFilesPanel.this.gettaDescription().setText(((ModuleInfo)SelectUpdateFilesPanel.this.getlModules().getSelectedValue()).getDescription());
                }
            }
        });
        this.getlModules().setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ModuleInfo moduleInfo = (ModuleInfo)value;
                this.setIcon(null);
                if (moduleInfo.getType().equals("language")) {
                    this.setIcon(Global.getIcon("Language.gif"));
                }
                this.setText(moduleInfo.getName() + " (" + Language.getString("wizard.update.categories." + moduleInfo.getType(), moduleInfo.getType()) + ")");
                return this;
            }
        });
    }

    public void addButton_ActionEvents() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setDialogTitle(this.getTitle());
        fileChooser.setCurrentDirectory(new File(this.lastDirectory));
        LogoFileFilter updateFilter = new LogoFileFilter("luf", Language.getString("wizard.update.selectUpdateFilesPanel.fileChooser.logoUpdate", "LOGO!Soft Comfort updates"));
        fileChooser.addChoosableFileFilter(updateFilter);
        fileChooser.showOpenDialog(this);
        File[] selected = fileChooser.getSelectedFiles();
        if (selected == null || selected.length == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            selected = new File[]{selectedFile};
        }
        this.lastDirectory = fileChooser.getCurrentDirectory().getPath();
        for (int i = 0; i < selected.length; ++i) {
            DefaultListModel dlm;
            ModuleInfo moduleInfo = null;
            try {
                moduleInfo = ((SelectUpdateFilesModel)this.panelModel).parseFile(selected[i]);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, Language.getString("wizard.update.selectUpdateFilesPanel.error.noModuleInfo", "The selected file contains no module info."), "SelectUpdate Files", 0);
                continue;
            }
            if (!this.isForCurrentVersion(moduleInfo) || (dlm = (DefaultListModel)this.getlModules().getModel()).contains(moduleInfo)) continue;
            dlm.addElement(moduleInfo);
        }
    }

    public boolean checkFieldContents() {
        if (this.getlModules().getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, Language.getString("wizard.update.selectModulesPanel.noModulesSelected", "No update selected."), this.getTitle(), 1);
            return false;
        }
        return true;
    }

    private void connEtoC1() {
        try {
            this.addButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.removeButton_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getaddButton() {
        if (this.ivjaddButton == null) {
            try {
                this.ivjaddButton = new JButton();
                this.ivjaddButton.setName("addButton");
                this.ivjaddButton.setText("hinzuf\u00fcgen");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjaddButton;
    }

    public Icon getIcon() {
        return null;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
                constraintsJScrollPane1.gridx = 0;
                constraintsJScrollPane1.gridy = 1;
                constraintsJScrollPane1.fill = 1;
                constraintsJScrollPane1.weightx = 1.0;
                constraintsJScrollPane1.weighty = 1.0;
                constraintsJScrollPane1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
                GridBagConstraints constraintsJPanel2 = new GridBagConstraints();
                constraintsJPanel2.gridx = 1;
                constraintsJPanel2.gridy = 1;
                constraintsJPanel2.fill = 1;
                constraintsJPanel2.weighty = 1.0;
                constraintsJPanel2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJPanel2(), constraintsJPanel2);
                GridBagConstraints constraintslblModules = new GridBagConstraints();
                constraintslblModules.gridx = 0;
                constraintslblModules.gridy = 0;
                constraintslblModules.anchor = 17;
                constraintslblModules.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getlblModules(), constraintslblModules);
                GridBagConstraints constraintslblDescription = new GridBagConstraints();
                constraintslblDescription.gridx = 0;
                constraintslblDescription.gridy = 2;
                constraintslblDescription.anchor = 17;
                constraintslblDescription.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getlblDescription(), constraintslblDescription);
                GridBagConstraints constraintsJScrollPane2 = new GridBagConstraints();
                constraintsJScrollPane2.gridx = 0;
                constraintsJScrollPane2.gridy = 3;
                constraintsJScrollPane2.gridwidth = 2;
                constraintsJScrollPane2.fill = 1;
                constraintsJScrollPane2.weightx = 1.0;
                constraintsJScrollPane2.weighty = 1.0;
                constraintsJScrollPane2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJScrollPane2(), constraintsJScrollPane2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints constraintsaddButton = new GridBagConstraints();
                constraintsaddButton.gridx = 0;
                constraintsaddButton.gridy = 0;
                constraintsaddButton.fill = 2;
                constraintsaddButton.insets = new Insets(4, 4, 4, 4);
                this.getJPanel2().add((Component)this.getaddButton(), constraintsaddButton);
                GridBagConstraints constraintsremoveButton = new GridBagConstraints();
                constraintsremoveButton.gridx = 0;
                constraintsremoveButton.gridy = 1;
                constraintsremoveButton.fill = 2;
                constraintsremoveButton.insets = new Insets(4, 4, 4, 4);
                this.getJPanel2().add((Component)this.getremoveButton(), constraintsremoveButton);
                GridBagConstraints constraintsJPanel3 = new GridBagConstraints();
                constraintsJPanel3.gridx = 0;
                constraintsJPanel3.gridy = 2;
                constraintsJPanel3.fill = 1;
                constraintsJPanel3.weightx = 1.0;
                constraintsJPanel3.weighty = 1.0;
                constraintsJPanel3.insets = new Insets(4, 4, 4, 4);
                this.getJPanel2().add((Component)this.getJPanel3(), constraintsJPanel3);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setLayout(null);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getlModules());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.ivjJScrollPane2 == null) {
            try {
                this.ivjJScrollPane2 = new JScrollPane();
                this.ivjJScrollPane2.setName("JScrollPane2");
                this.getJScrollPane2().setViewportView(this.gettaDescription());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane2;
    }

    private JLabel getlblDescription() {
        if (this.ivjlblDescription == null) {
            try {
                this.ivjlblDescription = new JLabel();
                this.ivjlblDescription.setName("lblDescription");
                this.ivjlblDescription.setText("Beschreibung");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblDescription;
    }

    private JLabel getlblModules() {
        if (this.ivjlblModules == null) {
            try {
                this.ivjlblModules = new JLabel();
                this.ivjlblModules.setName("lblModules");
                this.ivjlblModules.setText("Module");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblModules;
    }

    private JList getlModules() {
        if (this.ivjlModules == null) {
            try {
                this.ivjlModules = new JList();
                this.ivjlModules.setName("lModules");
                this.ivjlModules.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlModules;
    }

    private JButton getremoveButton() {
        if (this.ivjremoveButton == null) {
            try {
                this.ivjremoveButton = new JButton();
                this.ivjremoveButton.setName("removeButton");
                this.ivjremoveButton.setText("entfernen");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjremoveButton;
    }

    private JTextArea gettaDescription() {
        if (this.ivjtaDescription == null) {
            try {
                this.ivjtaDescription = new JTextArea();
                this.ivjtaDescription.setName("taDescription");
                this.ivjtaDescription.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtaDescription;
    }

    private void handleException(Throwable exception) {
    }

    public void handleProcessException(Exception e) {
        String errorText = null;
        if (e instanceof IOException && e.getMessage() != null && e.getMessage().equals("cantWrite")) {
            errorText = Language.getString("wizard.update.selectModulesPanel.error.cantWrite", "Can't write.");
        }
        if (errorText == null) {
            super.handleProcessException(e);
            return;
        }
        JOptionPane.showMessageDialog(this, errorText, this.getTitle(), 0);
    }

    private void initConnections() throws Exception {
        this.getaddButton().addActionListener(this.ivjEventHandler);
        this.getremoveButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("SelectUpdateFilesPanel");
            this.setLayout(new GridBagLayout());
            this.setSize(396, 297);
            GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
            constraintsJPanel1.gridx = 1;
            constraintsJPanel1.gridy = 1;
            constraintsJPanel1.fill = 1;
            constraintsJPanel1.weightx = 1.0;
            constraintsJPanel1.weighty = 1.0;
            this.add((Component)this.getJPanel1(), constraintsJPanel1);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.invalidate();
        this.validateTree();
    }

    public void initializeFieldContents() {
        this.lastDirectory = ((SelectUpdateFilesModel)this.panelModel).getLastDirectory();
    }

    protected boolean isForCurrentVersion(ModuleInfo moduleInfo) {
        Version currentVersion = Version.getCurrentVersion();
        if (currentVersion.compareTo(moduleInfo.validFromVersion) == -1 || currentVersion.compareTo(moduleInfo.validToVersion) == 1) {
            JOptionPane.showMessageDialog(this, Language.getString("wizard.update.selectUpdateFilesPanel.error.invalicVersion", "The selected update file isn't dedicated for your Version of LogoSoft!Comfort"), this.getTitle(), 0);
            return false;
        }
        return true;
    }

    public void loadFieldContents() {
        Enumeration modules = ((UpdateWizardModel)this.panelModel.getWizardModel()).getSelectedUpdateFiles().elements();
        DefaultListModel dlm = (DefaultListModel)this.getlModules().getModel();
        while (modules.hasMoreElements()) {
            dlm.addElement(modules.nextElement());
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            SelectUpdateFilesPanel aSelectUpdateFilesPanel = new SelectUpdateFilesPanel(null);
            frame.setContentPane(aSelectUpdateFilesPanel);
            frame.setSize(aSelectUpdateFilesPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.dialog.wizard.WizardInputPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void removeButton_ActionEvents() {
        Object[] selection = this.getlModules().getSelectedValues();
        this.getlModules().clearSelection();
        for (int i = 0; i < selection.length; ++i) {
            ((DefaultListModel)this.getlModules().getModel()).removeElement(selection[i]);
        }
    }

    public void setLabels() {
        this.setTitle(Language.getString("wizard.update.selectUpdateFilesPanel.title", "Select Update Files"));
        this.getlblModules().setText(Language.getString("wizard.update.selectUpdateFilesPanel.modules", "Selected Modules"));
        this.getaddButton().setText(Language.getString("wizard.update.selectUpdateFilesPanel.add", "Add"));
        this.getremoveButton().setText(Language.getString("wizard.update.selectUpdateFilesPanel.remove", "Remove"));
        this.getlblDescription().setText(Language.getString("wizard.update.selectUpdateFilesPanel.description", "Description"));
    }

    public void storeFieldContents() {
        Vector v = new Vector();
        for (int i = 0; i < this.getlModules().getModel().getSize(); ++i) {
            v.add(this.getlModules().getModel().getElementAt(i));
        }
        ((SelectUpdateFilesModel)this.panelModel).setSelectedModules(v);
        ((SelectUpdateFilesModel)this.panelModel).setLastDirectory(this.lastDirectory);
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SelectUpdateFilesPanel.this.getaddButton()) {
                SelectUpdateFilesPanel.this.connEtoC1();
            }
            if (e.getSource() == SelectUpdateFilesPanel.this.getremoveButton()) {
                SelectUpdateFilesPanel.this.connEtoC2();
            }
        }
    }
}

